// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Compute.Models
{
    internal static partial class ComputeResourceSkuCapacityScaleTypeExtensions
    {
        public static string ToSerialString(this ComputeResourceSkuCapacityScaleType value) => value switch
        {
            ComputeResourceSkuCapacityScaleType.None => "None",
            ComputeResourceSkuCapacityScaleType.Automatic => "Automatic",
            ComputeResourceSkuCapacityScaleType.Manual => "Manual",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ComputeResourceSkuCapacityScaleType value.")
        };

        public static ComputeResourceSkuCapacityScaleType ToComputeResourceSkuCapacityScaleType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return ComputeResourceSkuCapacityScaleType.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Automatic")) return ComputeResourceSkuCapacityScaleType.Automatic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Manual")) return ComputeResourceSkuCapacityScaleType.Manual;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ComputeResourceSkuCapacityScaleType value.");
        }
    }
}
