// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Specify public IP sku tier. </summary>
    public readonly partial struct ComputePublicIPAddressSkuTier : IEquatable<ComputePublicIPAddressSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputePublicIPAddressSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputePublicIPAddressSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegionalValue = "Regional";
        private const string GlobalValue = "Global";

        /// <summary> Regional. </summary>
        public static ComputePublicIPAddressSkuTier Regional { get; } = new ComputePublicIPAddressSkuTier(RegionalValue);
        /// <summary> Global. </summary>
        public static ComputePublicIPAddressSkuTier Global { get; } = new ComputePublicIPAddressSkuTier(GlobalValue);
        /// <summary> Determines if two <see cref="ComputePublicIPAddressSkuTier"/> values are the same. </summary>
        public static bool operator ==(ComputePublicIPAddressSkuTier left, ComputePublicIPAddressSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputePublicIPAddressSkuTier"/> values are not the same. </summary>
        public static bool operator !=(ComputePublicIPAddressSkuTier left, ComputePublicIPAddressSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputePublicIPAddressSkuTier"/>. </summary>
        public static implicit operator ComputePublicIPAddressSkuTier(string value) => new ComputePublicIPAddressSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputePublicIPAddressSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputePublicIPAddressSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
