// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct ComputePrivateEndpointConnectionProvisioningState : IEquatable<ComputePrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputePrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputePrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static ComputePrivateEndpointConnectionProvisioningState Succeeded { get; } = new ComputePrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static ComputePrivateEndpointConnectionProvisioningState Creating { get; } = new ComputePrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static ComputePrivateEndpointConnectionProvisioningState Deleting { get; } = new ComputePrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static ComputePrivateEndpointConnectionProvisioningState Failed { get; } = new ComputePrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="ComputePrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(ComputePrivateEndpointConnectionProvisioningState left, ComputePrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputePrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(ComputePrivateEndpointConnectionProvisioningState left, ComputePrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputePrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator ComputePrivateEndpointConnectionProvisioningState(string value) => new ComputePrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputePrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputePrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
