// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Specifies the allocation strategy for the virtual machine scale set based on which the VMs will be allocated. </summary>
    public readonly partial struct ComputeAllocationStrategy : IEquatable<ComputeAllocationStrategy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ComputeAllocationStrategy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ComputeAllocationStrategy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowestPriceValue = "LowestPrice";
        private const string CapacityOptimizedValue = "CapacityOptimized";

        /// <summary> LowestPrice. </summary>
        public static ComputeAllocationStrategy LowestPrice { get; } = new ComputeAllocationStrategy(LowestPriceValue);
        /// <summary> CapacityOptimized. </summary>
        public static ComputeAllocationStrategy CapacityOptimized { get; } = new ComputeAllocationStrategy(CapacityOptimizedValue);
        /// <summary> Determines if two <see cref="ComputeAllocationStrategy"/> values are the same. </summary>
        public static bool operator ==(ComputeAllocationStrategy left, ComputeAllocationStrategy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ComputeAllocationStrategy"/> values are not the same. </summary>
        public static bool operator !=(ComputeAllocationStrategy left, ComputeAllocationStrategy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ComputeAllocationStrategy"/>. </summary>
        public static implicit operator ComputeAllocationStrategy(string value) => new ComputeAllocationStrategy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ComputeAllocationStrategy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ComputeAllocationStrategy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
