// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The metadata of community gallery. </summary>
    public partial class CommunityGalleryMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CommunityGalleryMetadata"/>. </summary>
        /// <param name="publisherContact"> The publisher email id of this community gallery. </param>
        /// <param name="publicNames"> A list of public names the gallery has. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="publisherContact"/> or <paramref name="publicNames"/> is null. </exception>
        internal CommunityGalleryMetadata(string publisherContact, IEnumerable<string> publicNames)
        {
            Argument.AssertNotNull(publisherContact, nameof(publisherContact));
            Argument.AssertNotNull(publicNames, nameof(publicNames));

            PublisherContact = publisherContact;
            PublicNames = publicNames.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="CommunityGalleryMetadata"/>. </summary>
        /// <param name="publisherUri"> The publisher URI of this community gallery. </param>
        /// <param name="publisherContact"> The publisher email id of this community gallery. </param>
        /// <param name="eula"> The end-user license agreement for this community gallery. </param>
        /// <param name="publicNames"> A list of public names the gallery has. </param>
        /// <param name="privacyStatementUri"> The link for the privacy statement of this community gallery from the gallery publisher. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CommunityGalleryMetadata(Uri publisherUri, string publisherContact, string eula, IReadOnlyList<string> publicNames, Uri privacyStatementUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PublisherUri = publisherUri;
            PublisherContact = publisherContact;
            Eula = eula;
            PublicNames = publicNames;
            PrivacyStatementUri = privacyStatementUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CommunityGalleryMetadata"/> for deserialization. </summary>
        internal CommunityGalleryMetadata()
        {
        }

        /// <summary> The publisher URI of this community gallery. </summary>
        public Uri PublisherUri { get; }
        /// <summary> The publisher email id of this community gallery. </summary>
        public string PublisherContact { get; }
        /// <summary> The end-user license agreement for this community gallery. </summary>
        public string Eula { get; }
        /// <summary> A list of public names the gallery has. </summary>
        public IReadOnlyList<string> PublicNames { get; }
        /// <summary> The link for the privacy statement of this community gallery from the gallery publisher. </summary>
        public Uri PrivacyStatementUri { get; }
    }
}
