// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary>
    /// Slot type for the cloud service.
    /// Possible values are &lt;br /&gt;&lt;br /&gt;**Production**&lt;br /&gt;&lt;br /&gt;**Staging**&lt;br /&gt;&lt;br /&gt;
    /// If not specified, the default value is Production.
    /// </summary>
    public readonly partial struct CloudServiceSlotType : IEquatable<CloudServiceSlotType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CloudServiceSlotType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CloudServiceSlotType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ProductionValue = "Production";
        private const string StagingValue = "Staging";

        /// <summary> Production. </summary>
        public static CloudServiceSlotType Production { get; } = new CloudServiceSlotType(ProductionValue);
        /// <summary> Staging. </summary>
        public static CloudServiceSlotType Staging { get; } = new CloudServiceSlotType(StagingValue);
        /// <summary> Determines if two <see cref="CloudServiceSlotType"/> values are the same. </summary>
        public static bool operator ==(CloudServiceSlotType left, CloudServiceSlotType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CloudServiceSlotType"/> values are not the same. </summary>
        public static bool operator !=(CloudServiceSlotType left, CloudServiceSlotType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CloudServiceSlotType"/>. </summary>
        public static implicit operator CloudServiceSlotType(string value) => new CloudServiceSlotType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CloudServiceSlotType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CloudServiceSlotType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
