// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> Network Profile for the cloud service. </summary>
    public partial class CloudServiceNetworkProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudServiceNetworkProfile"/>. </summary>
        public CloudServiceNetworkProfile()
        {
            LoadBalancerConfigurations = new ChangeTrackingList<CloudServiceLoadBalancerConfiguration>();
        }

        /// <summary> Initializes a new instance of <see cref="CloudServiceNetworkProfile"/>. </summary>
        /// <param name="loadBalancerConfigurations"> List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer. </param>
        /// <param name="slotType">
        /// Slot type for the cloud service.
        /// Possible values are &lt;br /&gt;&lt;br /&gt;**Production**&lt;br /&gt;&lt;br /&gt;**Staging**&lt;br /&gt;&lt;br /&gt;
        /// If not specified, the default value is Production.
        /// </param>
        /// <param name="swappableCloudService"> The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap. This property cannot be updated once it is set. The swappable cloud service referred by this id must be present otherwise an error will be thrown. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudServiceNetworkProfile(IList<CloudServiceLoadBalancerConfiguration> loadBalancerConfigurations, CloudServiceSlotType? slotType, WritableSubResource swappableCloudService, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LoadBalancerConfigurations = loadBalancerConfigurations;
            SlotType = slotType;
            SwappableCloudService = swappableCloudService;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of Load balancer configurations. Cloud service can have up to two load balancer configurations, corresponding to a Public Load Balancer and an Internal Load Balancer. </summary>
        public IList<CloudServiceLoadBalancerConfiguration> LoadBalancerConfigurations { get; }
        /// <summary>
        /// Slot type for the cloud service.
        /// Possible values are &lt;br /&gt;&lt;br /&gt;**Production**&lt;br /&gt;&lt;br /&gt;**Staging**&lt;br /&gt;&lt;br /&gt;
        /// If not specified, the default value is Production.
        /// </summary>
        public CloudServiceSlotType? SlotType { get; set; }
        /// <summary> The id reference of the cloud service containing the target IP with which the subject cloud service can perform a swap. This property cannot be updated once it is set. The swappable cloud service referred by this id must be present otherwise an error will be thrown. </summary>
        internal WritableSubResource SwappableCloudService { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier SwappableCloudServiceId
        {
            get => SwappableCloudService is null ? default : SwappableCloudService.Id;
            set
            {
                if (SwappableCloudService is null)
                    SwappableCloudService = new WritableSubResource();
                SwappableCloudService.Id = value;
            }
        }
    }
}
