// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> InstanceView of CloudService as a whole. </summary>
    public partial class CloudServiceInstanceView
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudServiceInstanceView"/>. </summary>
        internal CloudServiceInstanceView()
        {
            PrivateIds = new ChangeTrackingList<string>();
            Statuses = new ChangeTrackingList<ResourceInstanceViewStatus>();
        }

        /// <summary> Initializes a new instance of <see cref="CloudServiceInstanceView"/>. </summary>
        /// <param name="roleInstance"> Instance view statuses. </param>
        /// <param name="sdkVersion"> The version of the SDK that was used to generate the package for the cloud service. </param>
        /// <param name="privateIds"> Specifies a list of unique identifiers generated internally for the cloud service. &lt;br /&gt;&lt;br /&gt; NOTE: If you are using Azure Diagnostics extension, this property can be used as 'DeploymentId' for querying details. </param>
        /// <param name="statuses"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudServiceInstanceView(InstanceViewStatusesSummary roleInstance, string sdkVersion, IReadOnlyList<string> privateIds, IReadOnlyList<ResourceInstanceViewStatus> statuses, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RoleInstance = roleInstance;
            SdkVersion = sdkVersion;
            PrivateIds = privateIds;
            Statuses = statuses;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Instance view statuses. </summary>
        internal InstanceViewStatusesSummary RoleInstance { get; }
        /// <summary> The summary. </summary>
        public IReadOnlyList<StatusCodeCount> RoleInstanceStatusesSummary
        {
            get => RoleInstance?.StatusesSummary;
        }

        /// <summary> The version of the SDK that was used to generate the package for the cloud service. </summary>
        public string SdkVersion { get; }
        /// <summary> Specifies a list of unique identifiers generated internally for the cloud service. &lt;br /&gt;&lt;br /&gt; NOTE: If you are using Azure Diagnostics extension, this property can be used as 'DeploymentId' for querying details. </summary>
        public IReadOnlyList<string> PrivateIds { get; }
        /// <summary> Gets the statuses. </summary>
        public IReadOnlyList<ResourceInstanceViewStatus> Statuses { get; }
    }
}
