// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> The CapacityReservationInstanceViewType. </summary>
    public readonly partial struct CapacityReservationInstanceViewType : IEquatable<CapacityReservationInstanceViewType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CapacityReservationInstanceViewType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CapacityReservationInstanceViewType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InstanceViewValue = "instanceView";

        /// <summary> instanceView. </summary>
        public static CapacityReservationInstanceViewType InstanceView { get; } = new CapacityReservationInstanceViewType(InstanceViewValue);
        /// <summary> Determines if two <see cref="CapacityReservationInstanceViewType"/> values are the same. </summary>
        public static bool operator ==(CapacityReservationInstanceViewType left, CapacityReservationInstanceViewType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CapacityReservationInstanceViewType"/> values are not the same. </summary>
        public static bool operator !=(CapacityReservationInstanceViewType left, CapacityReservationInstanceViewType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CapacityReservationInstanceViewType"/>. </summary>
        public static implicit operator CapacityReservationInstanceViewType(string value) => new CapacityReservationInstanceViewType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CapacityReservationInstanceViewType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CapacityReservationInstanceViewType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
