// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Compute.Models
{
    /// <summary> A disk access SAS uri. </summary>
    public partial class AccessUri
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AccessUri"/>. </summary>
        internal AccessUri()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AccessUri"/>. </summary>
        /// <param name="accessSas"> A SAS uri for accessing a disk. </param>
        /// <param name="securityDataAccessSas"> A SAS uri for accessing a VM guest state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AccessUri(string accessSas, string securityDataAccessSas, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AccessSas = accessSas;
            SecurityDataAccessSas = securityDataAccessSas;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A SAS uri for accessing a disk. </summary>
        public string AccessSas { get; }
        /// <summary> A SAS uri for accessing a VM guest state. </summary>
        public string SecurityDataAccessSas { get; }
    }
}
