// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Compute
{
    internal class VirtualMachineScaleSetVmRunCommandOperationSource : IOperationSource<VirtualMachineScaleSetVmRunCommandResource>
    {
        private readonly ArmClient _client;

        internal VirtualMachineScaleSetVmRunCommandOperationSource(ArmClient client)
        {
            _client = client;
        }

        VirtualMachineScaleSetVmRunCommandResource IOperationSource<VirtualMachineScaleSetVmRunCommandResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = VirtualMachineRunCommandData.DeserializeVirtualMachineRunCommandData(document.RootElement);
            return new VirtualMachineScaleSetVmRunCommandResource(_client, data);
        }

        async ValueTask<VirtualMachineScaleSetVmRunCommandResource> IOperationSource<VirtualMachineScaleSetVmRunCommandResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = VirtualMachineRunCommandData.DeserializeVirtualMachineRunCommandData(document.RootElement);
            return new VirtualMachineScaleSetVmRunCommandResource(_client, data);
        }
    }
}
