// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Compute
{
    internal class SnapshotOperationSource : IOperationSource<SnapshotResource>
    {
        private readonly ArmClient _client;

        internal SnapshotOperationSource(ArmClient client)
        {
            _client = client;
        }

        SnapshotResource IOperationSource<SnapshotResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SnapshotData.DeserializeSnapshotData(document.RootElement);
            return new SnapshotResource(_client, data);
        }

        async ValueTask<SnapshotResource> IOperationSource<SnapshotResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SnapshotData.DeserializeSnapshotData(document.RootElement);
            return new SnapshotResource(_client, data);
        }
    }
}
