// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Compute
{
    internal class ManagedDiskOperationSource : IOperationSource<ManagedDiskResource>
    {
        private readonly ArmClient _client;

        internal ManagedDiskOperationSource(ArmClient client)
        {
            _client = client;
        }

        ManagedDiskResource IOperationSource<ManagedDiskResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ManagedDiskData.DeserializeManagedDiskData(document.RootElement);
            return new ManagedDiskResource(_client, data);
        }

        async ValueTask<ManagedDiskResource> IOperationSource<ManagedDiskResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ManagedDiskData.DeserializeManagedDiskData(document.RootElement);
            return new ManagedDiskResource(_client, data);
        }
    }
}
