// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Compute
{
    internal class GalleryOperationSource : IOperationSource<GalleryResource>
    {
        private readonly ArmClient _client;

        internal GalleryOperationSource(ArmClient client)
        {
            _client = client;
        }

        GalleryResource IOperationSource<GalleryResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GalleryData.DeserializeGalleryData(document.RootElement);
            return new GalleryResource(_client, data);
        }

        async ValueTask<GalleryResource> IOperationSource<GalleryResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GalleryData.DeserializeGalleryData(document.RootElement);
            return new GalleryResource(_client, data);
        }
    }
}
