// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Compute
{
    internal class DiskImageOperationSource : IOperationSource<DiskImageResource>
    {
        private readonly ArmClient _client;

        internal DiskImageOperationSource(ArmClient client)
        {
            _client = client;
        }

        DiskImageResource IOperationSource<DiskImageResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DiskImageData.DeserializeDiskImageData(document.RootElement);
            return new DiskImageResource(_client, data);
        }

        async ValueTask<DiskImageResource> IOperationSource<DiskImageResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DiskImageData.DeserializeDiskImageData(document.RootElement);
            return new DiskImageResource(_client, data);
        }
    }
}
