// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Compute
{
    internal class DiskAccessOperationSource : IOperationSource<DiskAccessResource>
    {
        private readonly ArmClient _client;

        internal DiskAccessOperationSource(ArmClient client)
        {
            _client = client;
        }

        DiskAccessResource IOperationSource<DiskAccessResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DiskAccessData.DeserializeDiskAccessData(document.RootElement);
            return new DiskAccessResource(_client, data);
        }

        async ValueTask<DiskAccessResource> IOperationSource<DiskAccessResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DiskAccessData.DeserializeDiskAccessData(document.RootElement);
            return new DiskAccessResource(_client, data);
        }
    }
}
