// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Compute
{
    internal class ComputePrivateEndpointConnectionOperationSource : IOperationSource<ComputePrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal ComputePrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        ComputePrivateEndpointConnectionResource IOperationSource<ComputePrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ComputePrivateEndpointConnectionData.DeserializeComputePrivateEndpointConnectionData(document.RootElement);
            return new ComputePrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<ComputePrivateEndpointConnectionResource> IOperationSource<ComputePrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ComputePrivateEndpointConnectionData.DeserializeComputePrivateEndpointConnectionData(document.RootElement);
            return new ComputePrivateEndpointConnectionResource(_client, data);
        }
    }
}
