// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Compute
{
    internal class CloudServiceOperationSource : IOperationSource<CloudServiceResource>
    {
        private readonly ArmClient _client;

        internal CloudServiceOperationSource(ArmClient client)
        {
            _client = client;
        }

        CloudServiceResource IOperationSource<CloudServiceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = CloudServiceData.DeserializeCloudServiceData(document.RootElement);
            return new CloudServiceResource(_client, data);
        }

        async ValueTask<CloudServiceResource> IOperationSource<CloudServiceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = CloudServiceData.DeserializeCloudServiceData(document.RootElement);
            return new CloudServiceResource(_client, data);
        }
    }
}
