// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Compute.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Compute
{
    /// <summary>
    /// A class representing the DiskRestorePoint data model.
    /// Properties of disk restore point
    /// </summary>
    public partial class DiskRestorePointData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DiskRestorePointData"/>. </summary>
        internal DiskRestorePointData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DiskRestorePointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="timeCreated"> The timestamp of restorePoint creation. </param>
        /// <param name="sourceResourceId"> arm id of source disk or source disk restore point. </param>
        /// <param name="osType"> The Operating System type. </param>
        /// <param name="hyperVGeneration"> The hypervisor generation of the Virtual Machine. Applicable to OS disks only. </param>
        /// <param name="purchasePlan"> Purchase plan information for the the image from which the OS disk was created. </param>
        /// <param name="supportedCapabilities"> List of supported capabilities for the image from which the OS disk was created. </param>
        /// <param name="familyId"> id of the backing snapshot's MIS family. </param>
        /// <param name="sourceUniqueId"> unique incarnation id of the source disk. </param>
        /// <param name="encryption"> Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys. </param>
        /// <param name="supportsHibernation"> Indicates the OS on a disk supports hibernation. </param>
        /// <param name="networkAccessPolicy"> Policy for accessing the disk via network. </param>
        /// <param name="publicNetworkAccess"> Policy for controlling export on the disk. </param>
        /// <param name="diskAccessId"> ARM id of the DiskAccess resource for using private endpoints on disks. </param>
        /// <param name="completionPercent"> Percentage complete for the background copy of disk restore point when source resource is from a different region. </param>
        /// <param name="replicationState"> Replication state of disk restore point when source resource is from a different region. </param>
        /// <param name="sourceResourceLocation"> Location of source disk or source disk restore point when source resource is from a different region. </param>
        /// <param name="securityProfile"> Contains the security related information for the resource. </param>
        /// <param name="logicalSectorSize"> Logical sector size in bytes for disk restore points of UltraSSD_LRS and PremiumV2_LRS disks. Supported values are 512 and 4096. 4096 is the default. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DiskRestorePointData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? timeCreated, ResourceIdentifier sourceResourceId, SupportedOperatingSystemType? osType, HyperVGeneration? hyperVGeneration, DiskPurchasePlan purchasePlan, SupportedCapabilities supportedCapabilities, string familyId, string sourceUniqueId, DiskEncryption encryption, bool? supportsHibernation, NetworkAccessPolicy? networkAccessPolicy, DiskPublicNetworkAccess? publicNetworkAccess, ResourceIdentifier diskAccessId, float? completionPercent, string replicationState, AzureLocation? sourceResourceLocation, DiskSecurityProfile securityProfile, int? logicalSectorSize, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            TimeCreated = timeCreated;
            SourceResourceId = sourceResourceId;
            OSType = osType;
            HyperVGeneration = hyperVGeneration;
            PurchasePlan = purchasePlan;
            SupportedCapabilities = supportedCapabilities;
            FamilyId = familyId;
            SourceUniqueId = sourceUniqueId;
            Encryption = encryption;
            SupportsHibernation = supportsHibernation;
            NetworkAccessPolicy = networkAccessPolicy;
            PublicNetworkAccess = publicNetworkAccess;
            DiskAccessId = diskAccessId;
            CompletionPercent = completionPercent;
            ReplicationState = replicationState;
            SourceResourceLocation = sourceResourceLocation;
            SecurityProfile = securityProfile;
            LogicalSectorSize = logicalSectorSize;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The timestamp of restorePoint creation. </summary>
        public DateTimeOffset? TimeCreated { get; }
        /// <summary> arm id of source disk or source disk restore point. </summary>
        public ResourceIdentifier SourceResourceId { get; }
        /// <summary> The Operating System type. </summary>
        public SupportedOperatingSystemType? OSType { get; }
        /// <summary> The hypervisor generation of the Virtual Machine. Applicable to OS disks only. </summary>
        public HyperVGeneration? HyperVGeneration { get; }
        /// <summary> Purchase plan information for the the image from which the OS disk was created. </summary>
        public DiskPurchasePlan PurchasePlan { get; }
        /// <summary> List of supported capabilities for the image from which the OS disk was created. </summary>
        public SupportedCapabilities SupportedCapabilities { get; }
        /// <summary> id of the backing snapshot's MIS family. </summary>
        public string FamilyId { get; }
        /// <summary> unique incarnation id of the source disk. </summary>
        public string SourceUniqueId { get; }
        /// <summary> Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys. </summary>
        public DiskEncryption Encryption { get; }
        /// <summary> Indicates the OS on a disk supports hibernation. </summary>
        public bool? SupportsHibernation { get; }
        /// <summary> Policy for accessing the disk via network. </summary>
        public NetworkAccessPolicy? NetworkAccessPolicy { get; }
        /// <summary> Policy for controlling export on the disk. </summary>
        public DiskPublicNetworkAccess? PublicNetworkAccess { get; }
        /// <summary> ARM id of the DiskAccess resource for using private endpoints on disks. </summary>
        public ResourceIdentifier DiskAccessId { get; }
        /// <summary> Percentage complete for the background copy of disk restore point when source resource is from a different region. </summary>
        public float? CompletionPercent { get; }
        /// <summary> Replication state of disk restore point when source resource is from a different region. </summary>
        public string ReplicationState { get; }
        /// <summary> Location of source disk or source disk restore point when source resource is from a different region. </summary>
        public AzureLocation? SourceResourceLocation { get; }
        /// <summary> Contains the security related information for the resource. </summary>
        public DiskSecurityProfile SecurityProfile { get; }
        /// <summary> Logical sector size in bytes for disk restore points of UltraSSD_LRS and PremiumV2_LRS disks. Supported values are 512 and 4096. 4096 is the default. </summary>
        public int? LogicalSectorSize { get; }
    }
}
