// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Compute.Models;

namespace Azure.ResourceManager.Compute
{
    /// <summary>
    /// A class representing the CommunityGallery data model.
    /// Specifies information about the Community Gallery that you want to create or update.
    /// </summary>
    public partial class CommunityGalleryData : PirCommunityGalleryResourceData
    {
        /// <summary> Initializes a new instance of <see cref="CommunityGalleryData"/>. </summary>
        internal CommunityGalleryData()
        {
            ArtifactTags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="CommunityGalleryData"/>. </summary>
        /// <param name="name"> Resource name. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="resourceType"> Resource type. </param>
        /// <param name="uniqueId"> The unique id of this community gallery. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="disclaimer"> The disclaimer for a community gallery resource. </param>
        /// <param name="artifactTags"> The artifact tags of a community gallery resource. </param>
        /// <param name="communityMetadata"> The metadata of community gallery. </param>
        internal CommunityGalleryData(string name, AzureLocation? location, ResourceType? resourceType, string uniqueId, IDictionary<string, BinaryData> serializedAdditionalRawData, string disclaimer, IReadOnlyDictionary<string, string> artifactTags, CommunityGalleryMetadata communityMetadata) : base(name, location, resourceType, uniqueId, serializedAdditionalRawData)
        {
            Disclaimer = disclaimer;
            ArtifactTags = artifactTags;
            CommunityMetadata = communityMetadata;
        }

        /// <summary> The disclaimer for a community gallery resource. </summary>
        public string Disclaimer { get; }
        /// <summary> The artifact tags of a community gallery resource. </summary>
        public IReadOnlyDictionary<string, string> ArtifactTags { get; }
        /// <summary> The metadata of community gallery. </summary>
        public CommunityGalleryMetadata CommunityMetadata { get; }
        /// <summary> The resource identifier. </summary>
        public ResourceIdentifier Id { get; internal set; }
    }
}
