// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Compute.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Compute
{
    /// <summary>
    /// A class representing the CloudServiceOSFamily data model.
    /// Describes a cloud service OS family.
    /// </summary>
    public partial class CloudServiceOSFamilyData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CloudServiceOSFamilyData"/>. </summary>
        internal CloudServiceOSFamilyData()
        {
            Versions = new ChangeTrackingList<OSVersionPropertiesBase>();
        }

        /// <summary> Initializes a new instance of <see cref="CloudServiceOSFamilyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resourceName"> Resource name. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="osFamilyName"> The OS family name. </param>
        /// <param name="label"> The OS family label. </param>
        /// <param name="versions"> List of OS versions belonging to this family. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CloudServiceOSFamilyData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string resourceName, AzureLocation? location, string osFamilyName, string label, IReadOnlyList<OSVersionPropertiesBase> versions, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ResourceName = resourceName;
            Location = location;
            OSFamilyName = osFamilyName;
            Label = label;
            Versions = versions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource name. </summary>
        public string ResourceName { get; }
        /// <summary> Resource location. </summary>
        public AzureLocation? Location { get; }
        /// <summary> The OS family name. </summary>
        public string OSFamilyName { get; }
        /// <summary> The OS family label. </summary>
        public string Label { get; }
        /// <summary> List of OS versions belonging to this family. </summary>
        public IReadOnlyList<OSVersionPropertiesBase> Versions { get; }
    }
}
