// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Compute.Models;

namespace Azure.ResourceManager.Compute.Samples
{
    public partial class Sample_GalleryApplicationCollection
    {
        // Create or update a simple gallery Application.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateASimpleGalleryApplication()
        {
            // Generated from example definition: specification/compute/resource-manager/Microsoft.Compute/GalleryRP/stable/2023-07-03/examples/galleryExamples/GalleryApplication_Create.json
            // this example is just showing the usage of "GalleryApplications_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GalleryResource created on azure
            // for more information of creating GalleryResource, please refer to the document of GalleryResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "myResourceGroup";
            string galleryName = "myGalleryName";
            ResourceIdentifier galleryResourceId = GalleryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, galleryName);
            GalleryResource gallery = client.GetGalleryResource(galleryResourceId);

            // get the collection of this GalleryApplicationResource
            GalleryApplicationCollection collection = gallery.GetGalleryApplications();

            // invoke the operation
            string galleryApplicationName = "myGalleryApplicationName";
            GalleryApplicationData data = new GalleryApplicationData(new AzureLocation("West US"))
            {
                Description = "This is the gallery application description.",
                Eula = "This is the gallery application EULA.",
                PrivacyStatementUri = new Uri("myPrivacyStatementUri}"),
                ReleaseNoteUri = new Uri("myReleaseNoteUri"),
                SupportedOSType = SupportedOperatingSystemType.Windows,
                CustomActions =
{
new GalleryApplicationCustomAction("myCustomAction","myCustomActionScript")
{
Description = "This is the custom action description.",
Parameters =
{
new GalleryApplicationCustomActionParameter("myCustomActionParameter")
{
IsRequired = false,
ParameterType = GalleryApplicationCustomActionParameterType.String,
DefaultValue = "default value of parameter.",
Description = "This is the description of the parameter",
}
},
}
},
            };
            ArmOperation<GalleryApplicationResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, galleryApplicationName, data);
            GalleryApplicationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GalleryApplicationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a gallery Application.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAGalleryApplication()
        {
            // Generated from example definition: specification/compute/resource-manager/Microsoft.Compute/GalleryRP/stable/2023-07-03/examples/galleryExamples/GalleryApplication_Get.json
            // this example is just showing the usage of "GalleryApplications_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GalleryResource created on azure
            // for more information of creating GalleryResource, please refer to the document of GalleryResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "myResourceGroup";
            string galleryName = "myGalleryName";
            ResourceIdentifier galleryResourceId = GalleryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, galleryName);
            GalleryResource gallery = client.GetGalleryResource(galleryResourceId);

            // get the collection of this GalleryApplicationResource
            GalleryApplicationCollection collection = gallery.GetGalleryApplications();

            // invoke the operation
            string galleryApplicationName = "myGalleryApplicationName";
            GalleryApplicationResource result = await collection.GetAsync(galleryApplicationName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            GalleryApplicationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a gallery Application.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAGalleryApplication()
        {
            // Generated from example definition: specification/compute/resource-manager/Microsoft.Compute/GalleryRP/stable/2023-07-03/examples/galleryExamples/GalleryApplication_Get.json
            // this example is just showing the usage of "GalleryApplications_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GalleryResource created on azure
            // for more information of creating GalleryResource, please refer to the document of GalleryResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "myResourceGroup";
            string galleryName = "myGalleryName";
            ResourceIdentifier galleryResourceId = GalleryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, galleryName);
            GalleryResource gallery = client.GetGalleryResource(galleryResourceId);

            // get the collection of this GalleryApplicationResource
            GalleryApplicationCollection collection = gallery.GetGalleryApplications();

            // invoke the operation
            string galleryApplicationName = "myGalleryApplicationName";
            bool result = await collection.ExistsAsync(galleryApplicationName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get a gallery Application.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAGalleryApplication()
        {
            // Generated from example definition: specification/compute/resource-manager/Microsoft.Compute/GalleryRP/stable/2023-07-03/examples/galleryExamples/GalleryApplication_Get.json
            // this example is just showing the usage of "GalleryApplications_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GalleryResource created on azure
            // for more information of creating GalleryResource, please refer to the document of GalleryResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "myResourceGroup";
            string galleryName = "myGalleryName";
            ResourceIdentifier galleryResourceId = GalleryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, galleryName);
            GalleryResource gallery = client.GetGalleryResource(galleryResourceId);

            // get the collection of this GalleryApplicationResource
            GalleryApplicationCollection collection = gallery.GetGalleryApplications();

            // invoke the operation
            string galleryApplicationName = "myGalleryApplicationName";
            NullableResponse<GalleryApplicationResource> response = await collection.GetIfExistsAsync(galleryApplicationName);
            GalleryApplicationResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                GalleryApplicationData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List gallery Applications in a gallery.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListGalleryApplicationsInAGallery()
        {
            // Generated from example definition: specification/compute/resource-manager/Microsoft.Compute/GalleryRP/stable/2023-07-03/examples/galleryExamples/GalleryApplication_ListByGallery.json
            // this example is just showing the usage of "GalleryApplications_ListByGallery" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this GalleryResource created on azure
            // for more information of creating GalleryResource, please refer to the document of GalleryResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "myResourceGroup";
            string galleryName = "myGalleryName";
            ResourceIdentifier galleryResourceId = GalleryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, galleryName);
            GalleryResource gallery = client.GetGalleryResource(galleryResourceId);

            // get the collection of this GalleryApplicationResource
            GalleryApplicationCollection collection = gallery.GetGalleryApplications();

            // invoke the operation and iterate over the result
            await foreach (GalleryApplicationResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                GalleryApplicationData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
