// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Compute.Samples
{
    public partial class Sample_CloudServiceRoleCollection
    {
        // Get Cloud Service Role
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetCloudServiceRole()
        {
            // Generated from example definition: specification/compute/resource-manager/Microsoft.Compute/CloudserviceRP/stable/2022-09-04/examples/CloudServiceRole_Get.json
            // this example is just showing the usage of "CloudServiceRoles_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CloudServiceResource created on azure
            // for more information of creating CloudServiceResource, please refer to the document of CloudServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "ConstosoRG";
            string cloudServiceName = "{cs-name}";
            ResourceIdentifier cloudServiceResourceId = CloudServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cloudServiceName);
            CloudServiceResource cloudService = client.GetCloudServiceResource(cloudServiceResourceId);

            // get the collection of this CloudServiceRoleResource
            CloudServiceRoleCollection collection = cloudService.GetCloudServiceRoles();

            // invoke the operation
            string roleName = "{role-name}";
            CloudServiceRoleResource result = await collection.GetAsync(roleName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            CloudServiceRoleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Cloud Service Role
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetCloudServiceRole()
        {
            // Generated from example definition: specification/compute/resource-manager/Microsoft.Compute/CloudserviceRP/stable/2022-09-04/examples/CloudServiceRole_Get.json
            // this example is just showing the usage of "CloudServiceRoles_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CloudServiceResource created on azure
            // for more information of creating CloudServiceResource, please refer to the document of CloudServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "ConstosoRG";
            string cloudServiceName = "{cs-name}";
            ResourceIdentifier cloudServiceResourceId = CloudServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cloudServiceName);
            CloudServiceResource cloudService = client.GetCloudServiceResource(cloudServiceResourceId);

            // get the collection of this CloudServiceRoleResource
            CloudServiceRoleCollection collection = cloudService.GetCloudServiceRoles();

            // invoke the operation
            string roleName = "{role-name}";
            bool result = await collection.ExistsAsync(roleName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Cloud Service Role
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetCloudServiceRole()
        {
            // Generated from example definition: specification/compute/resource-manager/Microsoft.Compute/CloudserviceRP/stable/2022-09-04/examples/CloudServiceRole_Get.json
            // this example is just showing the usage of "CloudServiceRoles_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CloudServiceResource created on azure
            // for more information of creating CloudServiceResource, please refer to the document of CloudServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "ConstosoRG";
            string cloudServiceName = "{cs-name}";
            ResourceIdentifier cloudServiceResourceId = CloudServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cloudServiceName);
            CloudServiceResource cloudService = client.GetCloudServiceResource(cloudServiceResourceId);

            // get the collection of this CloudServiceRoleResource
            CloudServiceRoleCollection collection = cloudService.GetCloudServiceRoles();

            // invoke the operation
            string roleName = "{role-name}";
            NullableResponse<CloudServiceRoleResource> response = await collection.GetIfExistsAsync(roleName);
            CloudServiceRoleResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                CloudServiceRoleData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List Roles in a Cloud Service
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListRolesInACloudService()
        {
            // Generated from example definition: specification/compute/resource-manager/Microsoft.Compute/CloudserviceRP/stable/2022-09-04/examples/CloudServiceRole_List.json
            // this example is just showing the usage of "CloudServiceRoles_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CloudServiceResource created on azure
            // for more information of creating CloudServiceResource, please refer to the document of CloudServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "ConstosoRG";
            string cloudServiceName = "{cs-name}";
            ResourceIdentifier cloudServiceResourceId = CloudServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, cloudServiceName);
            CloudServiceResource cloudService = client.GetCloudServiceResource(cloudServiceResourceId);

            // get the collection of this CloudServiceRoleResource
            CloudServiceRoleCollection collection = cloudService.GetCloudServiceRoles();

            // invoke the operation and iterate over the result
            await foreach (CloudServiceRoleResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                CloudServiceRoleData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
