// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Communication.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Communication
{
    /// <summary>
    /// A class representing the SenderUsernameResource data model.
    /// A class representing a SenderUsername resource.
    /// </summary>
    public partial class SenderUsernameResourceData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SenderUsernameResourceData"/>. </summary>
        public SenderUsernameResourceData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SenderUsernameResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="dataLocation"> The location where the SenderUsername resource data is stored at rest. </param>
        /// <param name="username"> A sender senderUsername to be used when sending emails. </param>
        /// <param name="displayName"> The display name for the senderUsername. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. Unknown is the default state for Communication Services. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SenderUsernameResourceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string dataLocation, string username, string displayName, CommunicationServiceProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DataLocation = dataLocation;
            Username = username;
            DisplayName = displayName;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The location where the SenderUsername resource data is stored at rest. </summary>
        [WirePath("properties.dataLocation")]
        public string DataLocation { get; }
        /// <summary> A sender senderUsername to be used when sending emails. </summary>
        [WirePath("properties.username")]
        public string Username { get; set; }
        /// <summary> The display name for the senderUsername. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> Provisioning state of the resource. Unknown is the default state for Communication Services. </summary>
        [WirePath("properties.provisioningState")]
        public CommunicationServiceProvisioningState? ProvisioningState { get; }
    }
}
