// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Communication.Models
{
    /// <summary> Provisioning state of the resource. </summary>
    public readonly partial struct EmailServicesProvisioningState : IEquatable<EmailServicesProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EmailServicesProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EmailServicesProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string RunningValue = "Running";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string MovingValue = "Moving";

        /// <summary> Unknown. </summary>
        public static EmailServicesProvisioningState Unknown { get; } = new EmailServicesProvisioningState(UnknownValue);
        /// <summary> Succeeded. </summary>
        public static EmailServicesProvisioningState Succeeded { get; } = new EmailServicesProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static EmailServicesProvisioningState Failed { get; } = new EmailServicesProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static EmailServicesProvisioningState Canceled { get; } = new EmailServicesProvisioningState(CanceledValue);
        /// <summary> Running. </summary>
        public static EmailServicesProvisioningState Running { get; } = new EmailServicesProvisioningState(RunningValue);
        /// <summary> Creating. </summary>
        public static EmailServicesProvisioningState Creating { get; } = new EmailServicesProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static EmailServicesProvisioningState Updating { get; } = new EmailServicesProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static EmailServicesProvisioningState Deleting { get; } = new EmailServicesProvisioningState(DeletingValue);
        /// <summary> Moving. </summary>
        public static EmailServicesProvisioningState Moving { get; } = new EmailServicesProvisioningState(MovingValue);
        /// <summary> Determines if two <see cref="EmailServicesProvisioningState"/> values are the same. </summary>
        public static bool operator ==(EmailServicesProvisioningState left, EmailServicesProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EmailServicesProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(EmailServicesProvisioningState left, EmailServicesProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EmailServicesProvisioningState"/>. </summary>
        public static implicit operator EmailServicesProvisioningState(string value) => new EmailServicesProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EmailServicesProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EmailServicesProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
