// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Communication.Models
{
    /// <summary> A class that represents a VerificationStatus record. </summary>
    public partial class DomainVerificationStatusRecord
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DomainVerificationStatusRecord"/>. </summary>
        internal DomainVerificationStatusRecord()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DomainVerificationStatusRecord"/>. </summary>
        /// <param name="status"> Status of the verification operation. </param>
        /// <param name="errorCode"> Error code. This property will only be present if the status is UnableToVerify. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DomainVerificationStatusRecord(DomainRecordVerificationStatus? status, string errorCode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            ErrorCode = errorCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Status of the verification operation. </summary>
        [WirePath("status")]
        public DomainRecordVerificationStatus? Status { get; }
        /// <summary> Error code. This property will only be present if the status is UnableToVerify. </summary>
        [WirePath("errorCode")]
        public string ErrorCode { get; }
    }
}
