// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Communication.Models
{
    /// <summary> Status of the verification operation. </summary>
    public readonly partial struct DomainRecordVerificationStatus : IEquatable<DomainRecordVerificationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DomainRecordVerificationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DomainRecordVerificationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotStartedValue = "NotStarted";
        private const string VerificationRequestedValue = "VerificationRequested";
        private const string VerificationInProgressValue = "VerificationInProgress";
        private const string VerificationFailedValue = "VerificationFailed";
        private const string VerifiedValue = "Verified";
        private const string CancellationRequestedValue = "CancellationRequested";

        /// <summary> NotStarted. </summary>
        public static DomainRecordVerificationStatus NotStarted { get; } = new DomainRecordVerificationStatus(NotStartedValue);
        /// <summary> VerificationRequested. </summary>
        public static DomainRecordVerificationStatus VerificationRequested { get; } = new DomainRecordVerificationStatus(VerificationRequestedValue);
        /// <summary> VerificationInProgress. </summary>
        public static DomainRecordVerificationStatus VerificationInProgress { get; } = new DomainRecordVerificationStatus(VerificationInProgressValue);
        /// <summary> VerificationFailed. </summary>
        public static DomainRecordVerificationStatus VerificationFailed { get; } = new DomainRecordVerificationStatus(VerificationFailedValue);
        /// <summary> Verified. </summary>
        public static DomainRecordVerificationStatus Verified { get; } = new DomainRecordVerificationStatus(VerifiedValue);
        /// <summary> CancellationRequested. </summary>
        public static DomainRecordVerificationStatus CancellationRequested { get; } = new DomainRecordVerificationStatus(CancellationRequestedValue);
        /// <summary> Determines if two <see cref="DomainRecordVerificationStatus"/> values are the same. </summary>
        public static bool operator ==(DomainRecordVerificationStatus left, DomainRecordVerificationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DomainRecordVerificationStatus"/> values are not the same. </summary>
        public static bool operator !=(DomainRecordVerificationStatus left, DomainRecordVerificationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DomainRecordVerificationStatus"/>. </summary>
        public static implicit operator DomainRecordVerificationStatus(string value) => new DomainRecordVerificationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DomainRecordVerificationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DomainRecordVerificationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
