// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Communication.Models
{
    /// <summary> Describes how a Domains resource is being managed. </summary>
    public readonly partial struct DomainManagement : IEquatable<DomainManagement>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DomainManagement"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DomainManagement(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AzureManagedValue = "AzureManaged";
        private const string CustomerManagedValue = "CustomerManaged";
        private const string CustomerManagedInExchangeOnlineValue = "CustomerManagedInExchangeOnline";

        /// <summary> AzureManaged. </summary>
        public static DomainManagement AzureManaged { get; } = new DomainManagement(AzureManagedValue);
        /// <summary> CustomerManaged. </summary>
        public static DomainManagement CustomerManaged { get; } = new DomainManagement(CustomerManagedValue);
        /// <summary> CustomerManagedInExchangeOnline. </summary>
        public static DomainManagement CustomerManagedInExchangeOnline { get; } = new DomainManagement(CustomerManagedInExchangeOnlineValue);
        /// <summary> Determines if two <see cref="DomainManagement"/> values are the same. </summary>
        public static bool operator ==(DomainManagement left, DomainManagement right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DomainManagement"/> values are not the same. </summary>
        public static bool operator !=(DomainManagement left, DomainManagement right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DomainManagement"/>. </summary>
        public static implicit operator DomainManagement(string value) => new DomainManagement(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DomainManagement other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DomainManagement other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
