// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Communication.Models
{
    /// <summary> Provisioning state of the resource. </summary>
    public readonly partial struct CommunicationServicesProvisioningState : IEquatable<CommunicationServicesProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CommunicationServicesProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CommunicationServicesProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string RunningValue = "Running";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string MovingValue = "Moving";

        /// <summary> Unknown. </summary>
        public static CommunicationServicesProvisioningState Unknown { get; } = new CommunicationServicesProvisioningState(UnknownValue);
        /// <summary> Succeeded. </summary>
        public static CommunicationServicesProvisioningState Succeeded { get; } = new CommunicationServicesProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static CommunicationServicesProvisioningState Failed { get; } = new CommunicationServicesProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static CommunicationServicesProvisioningState Canceled { get; } = new CommunicationServicesProvisioningState(CanceledValue);
        /// <summary> Running. </summary>
        public static CommunicationServicesProvisioningState Running { get; } = new CommunicationServicesProvisioningState(RunningValue);
        /// <summary> Creating. </summary>
        public static CommunicationServicesProvisioningState Creating { get; } = new CommunicationServicesProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static CommunicationServicesProvisioningState Updating { get; } = new CommunicationServicesProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static CommunicationServicesProvisioningState Deleting { get; } = new CommunicationServicesProvisioningState(DeletingValue);
        /// <summary> Moving. </summary>
        public static CommunicationServicesProvisioningState Moving { get; } = new CommunicationServicesProvisioningState(MovingValue);
        /// <summary> Determines if two <see cref="CommunicationServicesProvisioningState"/> values are the same. </summary>
        public static bool operator ==(CommunicationServicesProvisioningState left, CommunicationServicesProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CommunicationServicesProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(CommunicationServicesProvisioningState left, CommunicationServicesProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CommunicationServicesProvisioningState"/>. </summary>
        public static implicit operator CommunicationServicesProvisioningState(string value) => new CommunicationServicesProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CommunicationServicesProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CommunicationServicesProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
