// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Communication.Models
{
    /// <summary> A class representing update parameters for CommunicationService resource. </summary>
    public partial class CommunicationServiceResourcePatch : CommunicationAcceptTags
    {
        /// <summary> Initializes a new instance of <see cref="CommunicationServiceResourcePatch"/>. </summary>
        public CommunicationServiceResourcePatch()
        {
            LinkedDomains = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="CommunicationServiceResourcePatch"/>. </summary>
        /// <param name="tags"> Tags of the service which is a list of key value pairs that describe the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="identity"> Managed service identity (system assigned and/or user assigned identities). </param>
        /// <param name="linkedDomains"> List of email Domain resource Ids. </param>
        internal CommunicationServiceResourcePatch(IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData, ManagedServiceIdentity identity, IList<string> linkedDomains) : base(tags, serializedAdditionalRawData)
        {
            Identity = identity;
            LinkedDomains = linkedDomains;
        }

        /// <summary> Managed service identity (system assigned and/or user assigned identities). </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> List of email Domain resource Ids. </summary>
        [WirePath("properties.linkedDomains")]
        public IList<string> LinkedDomains { get; }
    }
}
