// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Communication.Models
{
    internal static partial class CommunicationServiceKeyTypeExtensions
    {
        public static string ToSerialString(this CommunicationServiceKeyType value) => value switch
        {
            CommunicationServiceKeyType.Primary => "Primary",
            CommunicationServiceKeyType.Secondary => "Secondary",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CommunicationServiceKeyType value.")
        };

        public static CommunicationServiceKeyType ToCommunicationServiceKeyType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Primary")) return CommunicationServiceKeyType.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Secondary")) return CommunicationServiceKeyType.Secondary;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown CommunicationServiceKeyType value.");
        }
    }
}
