// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Communication.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableCommunicationResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableCommunicationResourceGroupResource"/> class for mocking. </summary>
        protected MockableCommunicationResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableCommunicationResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableCommunicationResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of CommunicationServiceResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of CommunicationServiceResources and their operations over a CommunicationServiceResource. </returns>
        public virtual CommunicationServiceResourceCollection GetCommunicationServiceResources()
        {
            return GetCachedClient(client => new CommunicationServiceResourceCollection(client, Id));
        }

        /// <summary>
        /// Get the CommunicationService and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/communicationServices/{communicationServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CommunicationServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CommunicationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="communicationServiceName"> The name of the CommunicationService resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="communicationServiceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="communicationServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<CommunicationServiceResource>> GetCommunicationServiceResourceAsync(string communicationServiceName, CancellationToken cancellationToken = default)
        {
            return await GetCommunicationServiceResources().GetAsync(communicationServiceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get the CommunicationService and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/communicationServices/{communicationServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>CommunicationServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="CommunicationServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="communicationServiceName"> The name of the CommunicationService resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="communicationServiceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="communicationServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<CommunicationServiceResource> GetCommunicationServiceResource(string communicationServiceName, CancellationToken cancellationToken = default)
        {
            return GetCommunicationServiceResources().Get(communicationServiceName, cancellationToken);
        }

        /// <summary> Gets a collection of EmailServiceResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of EmailServiceResources and their operations over a EmailServiceResource. </returns>
        public virtual EmailServiceResourceCollection GetEmailServiceResources()
        {
            return GetCachedClient(client => new EmailServiceResourceCollection(client, Id));
        }

        /// <summary>
        /// Get the EmailService and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="EmailServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="emailServiceName"> The name of the EmailService resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="emailServiceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="emailServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<EmailServiceResource>> GetEmailServiceResourceAsync(string emailServiceName, CancellationToken cancellationToken = default)
        {
            return await GetEmailServiceResources().GetAsync(emailServiceName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get the EmailService and its properties.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EmailServices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="EmailServiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="emailServiceName"> The name of the EmailService resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="emailServiceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="emailServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<EmailServiceResource> GetEmailServiceResource(string emailServiceName, CancellationToken cancellationToken = default)
        {
            return GetEmailServiceResources().Get(emailServiceName, cancellationToken);
        }
    }
}
