// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Communication.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Communication
{
    /// <summary>
    /// A class representing the CommunicationServiceResource data model.
    /// A class representing a CommunicationService resource.
    /// </summary>
    public partial class CommunicationServiceResourceData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CommunicationServiceResourceData"/>. </summary>
        /// <param name="location"> The location. </param>
        public CommunicationServiceResourceData(AzureLocation location) : base(location)
        {
            LinkedDomains = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="CommunicationServiceResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Managed service identity (system assigned and/or user assigned identities). </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="hostName"> FQDN of the CommunicationService instance. </param>
        /// <param name="dataLocation"> The location where the communication service stores its data at rest. </param>
        /// <param name="notificationHubId"> Resource ID of an Azure Notification Hub linked to this resource. </param>
        /// <param name="version"> Version of the CommunicationService resource. Probably you need the same or higher version of client SDKs. </param>
        /// <param name="immutableResourceId"> The immutable resource Id of the communication service. </param>
        /// <param name="linkedDomains"> List of email Domain resource Ids. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CommunicationServiceResourceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, CommunicationServicesProvisioningState? provisioningState, string hostName, string dataLocation, ResourceIdentifier notificationHubId, string version, Guid? immutableResourceId, IList<string> linkedDomains, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            ProvisioningState = provisioningState;
            HostName = hostName;
            DataLocation = dataLocation;
            NotificationHubId = notificationHubId;
            Version = version;
            ImmutableResourceId = immutableResourceId;
            LinkedDomains = linkedDomains;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CommunicationServiceResourceData"/> for deserialization. </summary>
        internal CommunicationServiceResourceData()
        {
        }

        /// <summary> Managed service identity (system assigned and/or user assigned identities). </summary>
        [WirePath("identity")]
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> Provisioning state of the resource. </summary>
        [WirePath("properties.provisioningState")]
        public CommunicationServicesProvisioningState? ProvisioningState { get; }
        /// <summary> FQDN of the CommunicationService instance. </summary>
        [WirePath("properties.hostName")]
        public string HostName { get; }
        /// <summary> The location where the communication service stores its data at rest. </summary>
        [WirePath("properties.dataLocation")]
        public string DataLocation { get; set; }
        /// <summary> Resource ID of an Azure Notification Hub linked to this resource. </summary>
        [WirePath("properties.notificationHubId")]
        public ResourceIdentifier NotificationHubId { get; }
        /// <summary> Version of the CommunicationService resource. Probably you need the same or higher version of client SDKs. </summary>
        [WirePath("properties.version")]
        public string Version { get; }
        /// <summary> The immutable resource Id of the communication service. </summary>
        [WirePath("properties.immutableResourceId")]
        public Guid? ImmutableResourceId { get; }
        /// <summary> List of email Domain resource Ids. </summary>
        [WirePath("properties.linkedDomains")]
        public IList<string> LinkedDomains { get; }
    }
}
