// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Communication.Samples
{
    public partial class Sample_SenderUsernameResourceCollection
    {
        // Get SenderUsernames resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_GetSenderUsernamesResource()
        {
            // Generated from example definition: specification/communication/resource-manager/Microsoft.Communication/stable/2023-04-01/examples/senderUsernames/listByDomain.json
            // this example is just showing the usage of "SenderUsernames_ListByDomains" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CommunicationDomainResource created on azure
            // for more information of creating CommunicationDomainResource, please refer to the document of CommunicationDomainResource
            string subscriptionId = "11112222-3333-4444-5555-666677778888";
            string resourceGroupName = "contosoResourceGroup";
            string emailServiceName = "contosoEmailService";
            string domainName = "contoso.com";
            ResourceIdentifier communicationDomainResourceId = CommunicationDomainResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, emailServiceName, domainName);
            CommunicationDomainResource communicationDomainResource = client.GetCommunicationDomainResource(communicationDomainResourceId);

            // get the collection of this SenderUsernameResource
            SenderUsernameResourceCollection collection = communicationDomainResource.GetSenderUsernameResources();

            // invoke the operation and iterate over the result
            await foreach (SenderUsernameResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SenderUsernameResourceData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get SenderUsernames resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSenderUsernamesResource()
        {
            // Generated from example definition: specification/communication/resource-manager/Microsoft.Communication/stable/2023-04-01/examples/senderUsernames/get.json
            // this example is just showing the usage of "SenderUsernames_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CommunicationDomainResource created on azure
            // for more information of creating CommunicationDomainResource, please refer to the document of CommunicationDomainResource
            string subscriptionId = "11112222-3333-4444-5555-666677778888";
            string resourceGroupName = "contosoResourceGroup";
            string emailServiceName = "contosoEmailService";
            string domainName = "contoso.com";
            ResourceIdentifier communicationDomainResourceId = CommunicationDomainResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, emailServiceName, domainName);
            CommunicationDomainResource communicationDomainResource = client.GetCommunicationDomainResource(communicationDomainResourceId);

            // get the collection of this SenderUsernameResource
            SenderUsernameResourceCollection collection = communicationDomainResource.GetSenderUsernameResources();

            // invoke the operation
            string senderUsername = "contosoNewsAlerts";
            SenderUsernameResource result = await collection.GetAsync(senderUsername);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SenderUsernameResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get SenderUsernames resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetSenderUsernamesResource()
        {
            // Generated from example definition: specification/communication/resource-manager/Microsoft.Communication/stable/2023-04-01/examples/senderUsernames/get.json
            // this example is just showing the usage of "SenderUsernames_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CommunicationDomainResource created on azure
            // for more information of creating CommunicationDomainResource, please refer to the document of CommunicationDomainResource
            string subscriptionId = "11112222-3333-4444-5555-666677778888";
            string resourceGroupName = "contosoResourceGroup";
            string emailServiceName = "contosoEmailService";
            string domainName = "contoso.com";
            ResourceIdentifier communicationDomainResourceId = CommunicationDomainResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, emailServiceName, domainName);
            CommunicationDomainResource communicationDomainResource = client.GetCommunicationDomainResource(communicationDomainResourceId);

            // get the collection of this SenderUsernameResource
            SenderUsernameResourceCollection collection = communicationDomainResource.GetSenderUsernameResources();

            // invoke the operation
            string senderUsername = "contosoNewsAlerts";
            bool result = await collection.ExistsAsync(senderUsername);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get SenderUsernames resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetSenderUsernamesResource()
        {
            // Generated from example definition: specification/communication/resource-manager/Microsoft.Communication/stable/2023-04-01/examples/senderUsernames/get.json
            // this example is just showing the usage of "SenderUsernames_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CommunicationDomainResource created on azure
            // for more information of creating CommunicationDomainResource, please refer to the document of CommunicationDomainResource
            string subscriptionId = "11112222-3333-4444-5555-666677778888";
            string resourceGroupName = "contosoResourceGroup";
            string emailServiceName = "contosoEmailService";
            string domainName = "contoso.com";
            ResourceIdentifier communicationDomainResourceId = CommunicationDomainResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, emailServiceName, domainName);
            CommunicationDomainResource communicationDomainResource = client.GetCommunicationDomainResource(communicationDomainResourceId);

            // get the collection of this SenderUsernameResource
            SenderUsernameResourceCollection collection = communicationDomainResource.GetSenderUsernameResources();

            // invoke the operation
            string senderUsername = "contosoNewsAlerts";
            NullableResponse<SenderUsernameResource> response = await collection.GetIfExistsAsync(senderUsername);
            SenderUsernameResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SenderUsernameResourceData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create or update SenderUsernames resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateSenderUsernamesResource()
        {
            // Generated from example definition: specification/communication/resource-manager/Microsoft.Communication/stable/2023-04-01/examples/senderUsernames/createOrUpdate.json
            // this example is just showing the usage of "SenderUsernames_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this CommunicationDomainResource created on azure
            // for more information of creating CommunicationDomainResource, please refer to the document of CommunicationDomainResource
            string subscriptionId = "11112222-3333-4444-5555-666677778888";
            string resourceGroupName = "contosoResourceGroup";
            string emailServiceName = "contosoEmailService";
            string domainName = "contoso.com";
            ResourceIdentifier communicationDomainResourceId = CommunicationDomainResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, emailServiceName, domainName);
            CommunicationDomainResource communicationDomainResource = client.GetCommunicationDomainResource(communicationDomainResourceId);

            // get the collection of this SenderUsernameResource
            SenderUsernameResourceCollection collection = communicationDomainResource.GetSenderUsernameResources();

            // invoke the operation
            string senderUsername = "contosoNewsAlerts";
            SenderUsernameResourceData data = new SenderUsernameResourceData()
            {
                Username = "contosoNewsAlerts",
                DisplayName = "Contoso News Alerts",
            };
            ArmOperation<SenderUsernameResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, senderUsername, data);
            SenderUsernameResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SenderUsernameResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
