// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.Sms
{
    /// <summary> Response for a single recipient. </summary>
    public partial class SmsSendResult
    {
        /// <summary> Initializes a new instance of <see cref="SmsSendResult"/>. </summary>
        /// <param name="to"> The recipient's phone number in E.164 format. </param>
        /// <param name="httpStatusCode"> HTTP Status code. </param>
        /// <param name="successful"> Indicates if the message is processed successfully or not. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="to"/> is null. </exception>
        internal SmsSendResult(string to, int httpStatusCode, bool successful)
        {
            Argument.AssertNotNull(to, nameof(to));

            To = to;
            HttpStatusCode = httpStatusCode;
            Successful = successful;
        }

        /// <summary> Initializes a new instance of <see cref="SmsSendResult"/>. </summary>
        /// <param name="to"> The recipient's phone number in E.164 format. </param>
        /// <param name="messageId"> The identifier of the outgoing Sms message. Only present if message processed. </param>
        /// <param name="httpStatusCode"> HTTP Status code. </param>
        /// <param name="repeatabilityResult"> The result of a repeatable request with one of the case-insensitive values accepted or rejected. </param>
        /// <param name="successful"> Indicates if the message is processed successfully or not. </param>
        /// <param name="errorMessage"> Optional error message in case of 4xx/5xx/repeatable errors. </param>
        internal SmsSendResult(string to, string messageId, int httpStatusCode, SmsSendResponseItemRepeatabilityResult? repeatabilityResult, bool successful, string errorMessage)
        {
            To = to;
            MessageId = messageId;
            HttpStatusCode = httpStatusCode;
            RepeatabilityResult = repeatabilityResult;
            Successful = successful;
            ErrorMessage = errorMessage;
        }

        /// <summary> The recipient's phone number in E.164 format. </summary>
        public string To { get; }
        /// <summary> The identifier of the outgoing Sms message. Only present if message processed. </summary>
        public string MessageId { get; }
        /// <summary> HTTP Status code. </summary>
        public int HttpStatusCode { get; }
        /// <summary> Indicates if the message is processed successfully or not. </summary>
        public bool Successful { get; }
        /// <summary> Optional error message in case of 4xx/5xx/repeatable errors. </summary>
        public string ErrorMessage { get; }
    }
}
