// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.Sms
{
    /// <summary> The result of a repeatable request with one of the case-insensitive values accepted or rejected. </summary>
    internal readonly partial struct SmsSendResponseItemRepeatabilityResult : IEquatable<SmsSendResponseItemRepeatabilityResult>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SmsSendResponseItemRepeatabilityResult"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SmsSendResponseItemRepeatabilityResult(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "accepted";
        private const string RejectedValue = "rejected";

        /// <summary> accepted. </summary>
        public static SmsSendResponseItemRepeatabilityResult Accepted { get; } = new SmsSendResponseItemRepeatabilityResult(AcceptedValue);
        /// <summary> rejected. </summary>
        public static SmsSendResponseItemRepeatabilityResult Rejected { get; } = new SmsSendResponseItemRepeatabilityResult(RejectedValue);
        /// <summary> Determines if two <see cref="SmsSendResponseItemRepeatabilityResult"/> values are the same. </summary>
        public static bool operator ==(SmsSendResponseItemRepeatabilityResult left, SmsSendResponseItemRepeatabilityResult right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SmsSendResponseItemRepeatabilityResult"/> values are not the same. </summary>
        public static bool operator !=(SmsSendResponseItemRepeatabilityResult left, SmsSendResponseItemRepeatabilityResult right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SmsSendResponseItemRepeatabilityResult"/>. </summary>
        public static implicit operator SmsSendResponseItemRepeatabilityResult(string value) => new SmsSendResponseItemRepeatabilityResult(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SmsSendResponseItemRepeatabilityResult other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SmsSendResponseItemRepeatabilityResult other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
