// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Communication.Sms.Models
{
    internal partial class SmsSendResponse
    {
        internal static SmsSendResponse DeserializeSmsSendResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<SmsSendResult> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("value"u8))
                {
                    List<SmsSendResult> array = new List<SmsSendResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SmsSendResult.DeserializeSmsSendResult(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new SmsSendResponse(value);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SmsSendResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSmsSendResponse(document.RootElement);
        }
    }
}
