// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Communication.Sms
{
    /// <summary> Optional configuration for sending SMS messages. </summary>
    public partial class SmsSendOptions
    {
        /// <summary> Initializes a new instance of <see cref="SmsSendOptions"/>. </summary>
        /// <param name="enableDeliveryReport"> Enable this flag to receive a delivery report for this message on the Azure Resource EventGrid. </param>
        public SmsSendOptions(bool enableDeliveryReport)
        {
            EnableDeliveryReport = enableDeliveryReport;
        }

        /// <summary> Initializes a new instance of <see cref="SmsSendOptions"/>. </summary>
        /// <param name="enableDeliveryReport"> Enable this flag to receive a delivery report for this message on the Azure Resource EventGrid. </param>
        /// <param name="tag"> Use this field to provide metadata that will then be sent back in the corresponding Delivery Report. </param>
        /// <param name="deliveryReportTimeoutInSeconds"> Time to wait for a delivery report. After this time a delivery report with timeout error code is generated. </param>
        internal SmsSendOptions(bool enableDeliveryReport, string tag, int? deliveryReportTimeoutInSeconds)
        {
            EnableDeliveryReport = enableDeliveryReport;
            Tag = tag;
            DeliveryReportTimeoutInSeconds = deliveryReportTimeoutInSeconds;
        }

        /// <summary> Enable this flag to receive a delivery report for this message on the Azure Resource EventGrid. </summary>
        public bool EnableDeliveryReport { get; }
        /// <summary> Use this field to provide metadata that will then be sent back in the corresponding Delivery Report. </summary>
        public string Tag { get; set; }
        /// <summary> Time to wait for a delivery report. After this time a delivery report with timeout error code is generated. </summary>
        public int? DeliveryReportTimeoutInSeconds { get; set; }
    }
}
