// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.Sms.Models
{
    internal partial class SmsRecipient : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("to"u8);
            writer.WriteStringValue(To);
            if (Optional.IsDefined(RepeatabilityRequestId))
            {
                writer.WritePropertyName("repeatabilityRequestId"u8);
                writer.WriteStringValue(RepeatabilityRequestId);
            }
            if (Optional.IsDefined(RepeatabilityFirstSent))
            {
                writer.WritePropertyName("repeatabilityFirstSent"u8);
                writer.WriteStringValue(RepeatabilityFirstSent);
            }
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
