// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> Describes a messaging use case for a given content type by providing example messages. </summary>
    public partial class UseCase
    {
        /// <summary> Initializes a new instance of <see cref="UseCase"/>. </summary>
        public UseCase()
        {
            Examples = new ChangeTrackingList<MessageExampleSequence>();
        }

        /// <summary> Initializes a new instance of <see cref="UseCase"/>. </summary>
        /// <param name="contentCategory"> Indicates the messaging content category used in the program e.g. 'ringTones', 'smsChat', 'video', 'loyaltyProgramPointsPrizes', 'gifting', 'inApplicationBilling', 'textToScreen'. </param>
        /// <param name="examples"> Example messages to be sent to and from the end user for the indicated content type. </param>
        internal UseCase(MessageContentCategory? contentCategory, IList<MessageExampleSequence> examples)
        {
            ContentCategory = contentCategory;
            Examples = examples;
        }

        /// <summary> Indicates the messaging content category used in the program e.g. 'ringTones', 'smsChat', 'video', 'loyaltyProgramPointsPrizes', 'gifting', 'inApplicationBilling', 'textToScreen'. </summary>
        public MessageContentCategory? ContentCategory { get; set; }
        /// <summary> Example messages to be sent to and from the end user for the indicated content type. </summary>
        public IList<MessageExampleSequence> Examples { get; }
    }
}
