// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.ShortCodes.Models
{
    public partial class UseCase : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(ContentCategory))
            {
                writer.WritePropertyName("contentCategory"u8);
                writer.WriteStringValue(ContentCategory.Value.ToString());
            }
            if (Optional.IsCollectionDefined(Examples))
            {
                writer.WritePropertyName("examples"u8);
                writer.WriteStartArray();
                foreach (var item in Examples)
                {
                    writer.WriteObjectValue(item);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        internal static UseCase DeserializeUseCase(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            MessageContentCategory? contentCategory = default;
            IList<MessageExampleSequence> examples = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("contentCategory"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    contentCategory = new MessageContentCategory(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("examples"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MessageExampleSequence> array = new List<MessageExampleSequence>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MessageExampleSequence.DeserializeMessageExampleSequence(item));
                    }
                    examples = array;
                    continue;
                }
            }
            return new UseCase(contentCategory, examples ?? new ChangeTrackingList<MessageExampleSequence>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static UseCase FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeUseCase(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
