// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary>
    /// Represents a US Program Brief for acquiring a short code in the United States.
    /// A Program Brief provides vital information to the carriers about a messaging program or campaign that would be associated with a short code or alpha sender number.
    /// A Program Brief also provides specifics about the use case, the purpose and the consumer experience receiving the message.
    /// </summary>
    public partial class USProgramBrief
    {
        /// <summary> Initializes a new instance of <see cref="USProgramBrief"/>. </summary>
        /// <param name="id"> Program Brief Id. </param>
        public USProgramBrief(Guid id)
        {
            Id = id;
            ReviewNotes = new ChangeTrackingList<ReviewNote>();
            Costs = new ChangeTrackingList<ShortCodeCost>();
        }

        /// <summary> Initializes a new instance of <see cref="USProgramBrief"/>. </summary>
        /// <param name="id"> Program Brief Id. </param>
        /// <param name="status"> Program Brief status e.g. 'submitted', 'approved', etc. </param>
        /// <param name="number"> Number provisioned for the Program Brief e.g. 555555, 'CONTOSO'. </param>
        /// <param name="reviewNotes">
        /// Notes added to the Program Brief after being reviewed to help customer understand
        /// review results and necessary follow up actions.
        /// </param>
        /// <param name="costs"> Represents the costs tied to the number. </param>
        /// <param name="submissionDate"> Date and time when the Program Brief was submitted. </param>
        /// <param name="statusUpdatedDate"> Last date and time when the Program Brief status was updated. </param>
        /// <param name="programDetails"> ProgramDetails. </param>
        /// <param name="companyInformation"> CompanyInformation. </param>
        /// <param name="messageDetails"> MessageDetails. </param>
        /// <param name="trafficDetails"> TrafficDetails. </param>
        internal USProgramBrief(Guid id, ProgramBriefStatus? status, string number, IList<ReviewNote> reviewNotes, IList<ShortCodeCost> costs, DateTimeOffset? submissionDate, DateTimeOffset? statusUpdatedDate, ProgramDetails programDetails, CompanyInformation companyInformation, MessageDetails messageDetails, TrafficDetails trafficDetails)
        {
            Id = id;
            Status = status;
            Number = number;
            ReviewNotes = reviewNotes;
            Costs = costs;
            SubmissionDate = submissionDate;
            StatusUpdatedDate = statusUpdatedDate;
            ProgramDetails = programDetails;
            CompanyInformation = companyInformation;
            MessageDetails = messageDetails;
            TrafficDetails = trafficDetails;
        }

        /// <summary> Program Brief Id. </summary>
        public Guid Id { get; set; }
        /// <summary> Program Brief status e.g. 'submitted', 'approved', etc. </summary>
        public ProgramBriefStatus? Status { get; set; }
        /// <summary> Number provisioned for the Program Brief e.g. 555555, 'CONTOSO'. </summary>
        public string Number { get; set; }
        /// <summary>
        /// Notes added to the Program Brief after being reviewed to help customer understand
        /// review results and necessary follow up actions.
        /// </summary>
        public IList<ReviewNote> ReviewNotes { get; }
        /// <summary> Represents the costs tied to the number. </summary>
        public IList<ShortCodeCost> Costs { get; }
        /// <summary> Date and time when the Program Brief was submitted. </summary>
        public DateTimeOffset? SubmissionDate { get; set; }
        /// <summary> Last date and time when the Program Brief status was updated. </summary>
        public DateTimeOffset? StatusUpdatedDate { get; set; }
        /// <summary> ProgramDetails. </summary>
        public ProgramDetails ProgramDetails { get; set; }
        /// <summary> CompanyInformation. </summary>
        public CompanyInformation CompanyInformation { get; set; }
        /// <summary> MessageDetails. </summary>
        public MessageDetails MessageDetails { get; set; }
        /// <summary> TrafficDetails. </summary>
        public TrafficDetails TrafficDetails { get; set; }
    }
}
