// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> Represents a number, ShortCode or AlphaId, acquired in a given country. </summary>
    public partial class ShortCode
    {
        /// <summary> Initializes a new instance of <see cref="ShortCode"/>. </summary>
        internal ShortCode()
        {
            ProgramBriefIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ShortCode"/>. </summary>
        /// <param name="number"> The value of the ShortCode or the alpha numeric e.g. '555555', 'CONTOSO', etc. </param>
        /// <param name="numberType"> The type of number e.g. 'ShortCode', 'AlphaId'. </param>
        /// <param name="countryCode"> ISO 3166 2-char code representing the country e.g. 'US'. </param>
        /// <param name="programBriefIds"> Program Brief Name. </param>
        /// <param name="purchaseDate"> Date in which number was purchased. </param>
        internal ShortCode(string number, NumberType? numberType, string countryCode, IReadOnlyList<string> programBriefIds, DateTimeOffset? purchaseDate)
        {
            Number = number;
            NumberType = numberType;
            CountryCode = countryCode;
            ProgramBriefIds = programBriefIds;
            PurchaseDate = purchaseDate;
        }

        /// <summary> The value of the ShortCode or the alpha numeric e.g. '555555', 'CONTOSO', etc. </summary>
        public string Number { get; }
        /// <summary> The type of number e.g. 'ShortCode', 'AlphaId'. </summary>
        public NumberType? NumberType { get; }
        /// <summary> ISO 3166 2-char code representing the country e.g. 'US'. </summary>
        public string CountryCode { get; }
        /// <summary> Program Brief Name. </summary>
        public IReadOnlyList<string> ProgramBriefIds { get; }
        /// <summary> Date in which number was purchased. </summary>
        public DateTimeOffset? PurchaseDate { get; }
    }
}
