// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> Indicates how a program will be discoverable by the consumer. </summary>
    public readonly partial struct ProgramSignUpType : IEquatable<ProgramSignUpType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProgramSignUpType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProgramSignUpType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WebsiteValue = "website";
        private const string PointOfSaleValue = "pointOfSale";
        private const string SmsValue = "sms";
        private const string InteractiveVoiceResponseValue = "interactiveVoiceResponse";

        /// <summary> website. </summary>
        public static ProgramSignUpType Website { get; } = new ProgramSignUpType(WebsiteValue);
        /// <summary> pointOfSale. </summary>
        public static ProgramSignUpType PointOfSale { get; } = new ProgramSignUpType(PointOfSaleValue);
        /// <summary> sms. </summary>
        public static ProgramSignUpType Sms { get; } = new ProgramSignUpType(SmsValue);
        /// <summary> interactiveVoiceResponse. </summary>
        public static ProgramSignUpType InteractiveVoiceResponse { get; } = new ProgramSignUpType(InteractiveVoiceResponseValue);
        /// <summary> Determines if two <see cref="ProgramSignUpType"/> values are the same. </summary>
        public static bool operator ==(ProgramSignUpType left, ProgramSignUpType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProgramSignUpType"/> values are not the same. </summary>
        public static bool operator !=(ProgramSignUpType left, ProgramSignUpType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProgramSignUpType"/>. </summary>
        public static implicit operator ProgramSignUpType(string value) => new ProgramSignUpType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProgramSignUpType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProgramSignUpType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
