// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> The ProgramDetails. </summary>
    public partial class ProgramDetails
    {
        /// <summary> Initializes a new instance of <see cref="ProgramDetails"/>. </summary>
        public ProgramDetails()
        {
            PreferredVanityNumbers = new ChangeTrackingList<string>();
            SignUpTypes = new ChangeTrackingList<ProgramSignUpType>();
        }

        /// <summary> Initializes a new instance of <see cref="ProgramDetails"/>. </summary>
        /// <param name="isVanity"> Set to true if the request is for a vanity number. </param>
        /// <param name="preferredVanityNumbers">
        /// Priority ordered list of preferred vanity numbers.
        /// Vanity numbers should be 5 or 6 digit when number type is ShortCode.
        /// e.g. 555555, 222222.
        /// </param>
        /// <param name="numberType"> Type for desired numbers e.g. 'shortCode' or 'alphaId'. </param>
        /// <param name="isPoliticalCampaign"> Indicates whether the number will be used for political campaigns or not. </param>
        /// <param name="name">
        /// A program name that indicates the purpose of filling the Program Brief and how the number will be used for messaging.
        /// e.g. 'CONTOSO Shipping'
        /// </param>
        /// <param name="description"> Describes how and why the number will be used for messaging as part of the program. </param>
        /// <param name="url"> URL for the program or company. </param>
        /// <param name="signUpTypes"> Indicates how the consumer can sign up to the program e.g. 'website', 'pointOfSale' and/or 'sms'. </param>
        /// <param name="signUpUrl"> URL for "call to action" image for the program. </param>
        /// <param name="termsOfServiceUrl"> URL for program terms of service. </param>
        /// <param name="privacyPolicyUrl"> URL for privacy policy. </param>
        /// <param name="expectedDateOfService">
        /// Date in which SMS messages will start to be sent out.
        /// Should follow ISO 8601 internet format for datetimes.
        /// e.g. 2021-08-17T22:02:51.316Z, 2021-08-17T16:39:57-08:00, etc.
        /// </param>
        internal ProgramDetails(bool? isVanity, IList<string> preferredVanityNumbers, NumberType? numberType, bool? isPoliticalCampaign, string name, string description, Uri url, IList<ProgramSignUpType> signUpTypes, Uri signUpUrl, Uri termsOfServiceUrl, Uri privacyPolicyUrl, DateTimeOffset? expectedDateOfService)
        {
            IsVanity = isVanity;
            PreferredVanityNumbers = preferredVanityNumbers;
            NumberType = numberType;
            IsPoliticalCampaign = isPoliticalCampaign;
            Name = name;
            Description = description;
            Url = url;
            SignUpTypes = signUpTypes;
            SignUpUrl = signUpUrl;
            TermsOfServiceUrl = termsOfServiceUrl;
            PrivacyPolicyUrl = privacyPolicyUrl;
            ExpectedDateOfService = expectedDateOfService;
        }

        /// <summary> Set to true if the request is for a vanity number. </summary>
        public bool? IsVanity { get; set; }
        /// <summary>
        /// Priority ordered list of preferred vanity numbers.
        /// Vanity numbers should be 5 or 6 digit when number type is ShortCode.
        /// e.g. 555555, 222222.
        /// </summary>
        public IList<string> PreferredVanityNumbers { get; }
        /// <summary> Type for desired numbers e.g. 'shortCode' or 'alphaId'. </summary>
        public NumberType? NumberType { get; set; }
        /// <summary> Indicates whether the number will be used for political campaigns or not. </summary>
        public bool? IsPoliticalCampaign { get; set; }
        /// <summary>
        /// A program name that indicates the purpose of filling the Program Brief and how the number will be used for messaging.
        /// e.g. 'CONTOSO Shipping'
        /// </summary>
        public string Name { get; set; }
        /// <summary> Describes how and why the number will be used for messaging as part of the program. </summary>
        public string Description { get; set; }
        /// <summary> URL for the program or company. </summary>
        public Uri Url { get; set; }
        /// <summary> Indicates how the consumer can sign up to the program e.g. 'website', 'pointOfSale' and/or 'sms'. </summary>
        public IList<ProgramSignUpType> SignUpTypes { get; }
        /// <summary> URL for "call to action" image for the program. </summary>
        public Uri SignUpUrl { get; set; }
        /// <summary> URL for program terms of service. </summary>
        public Uri TermsOfServiceUrl { get; set; }
        /// <summary> URL for privacy policy. </summary>
        public Uri PrivacyPolicyUrl { get; set; }
        /// <summary>
        /// Date in which SMS messages will start to be sent out.
        /// Should follow ISO 8601 internet format for datetimes.
        /// e.g. 2021-08-17T22:02:51.316Z, 2021-08-17T16:39:57-08:00, etc.
        /// </summary>
        public DateTimeOffset? ExpectedDateOfService { get; set; }
    }
}
