// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.ShortCodes.Models
{
    public partial class ProgramDetails : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Optional.IsDefined(IsVanity))
            {
                writer.WritePropertyName("isVanity"u8);
                writer.WriteBooleanValue(IsVanity.Value);
            }
            if (Optional.IsCollectionDefined(PreferredVanityNumbers))
            {
                writer.WritePropertyName("preferredVanityNumbers"u8);
                writer.WriteStartArray();
                foreach (var item in PreferredVanityNumbers)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(NumberType))
            {
                writer.WritePropertyName("numberType"u8);
                writer.WriteStringValue(NumberType.Value.ToString());
            }
            if (Optional.IsDefined(IsPoliticalCampaign))
            {
                writer.WritePropertyName("isPoliticalCampaign"u8);
                writer.WriteBooleanValue(IsPoliticalCampaign.Value);
            }
            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(Url))
            {
                writer.WritePropertyName("url"u8);
                writer.WriteStringValue(Url.AbsoluteUri);
            }
            if (Optional.IsCollectionDefined(SignUpTypes))
            {
                writer.WritePropertyName("signUpTypes"u8);
                writer.WriteStartArray();
                foreach (var item in SignUpTypes)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(SignUpUrl))
            {
                writer.WritePropertyName("signUpUrl"u8);
                writer.WriteStringValue(SignUpUrl.AbsoluteUri);
            }
            if (Optional.IsDefined(TermsOfServiceUrl))
            {
                writer.WritePropertyName("termsOfServiceUrl"u8);
                writer.WriteStringValue(TermsOfServiceUrl.AbsoluteUri);
            }
            if (Optional.IsDefined(PrivacyPolicyUrl))
            {
                writer.WritePropertyName("privacyPolicyUrl"u8);
                writer.WriteStringValue(PrivacyPolicyUrl.AbsoluteUri);
            }
            if (Optional.IsDefined(ExpectedDateOfService))
            {
                writer.WritePropertyName("expectedDateOfService"u8);
                writer.WriteStringValue(ExpectedDateOfService.Value, "O");
            }
            writer.WriteEndObject();
        }

        internal static ProgramDetails DeserializeProgramDetails(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? isVanity = default;
            IList<string> preferredVanityNumbers = default;
            NumberType? numberType = default;
            bool? isPoliticalCampaign = default;
            string name = default;
            string description = default;
            Uri url = default;
            IList<ProgramSignUpType> signUpTypes = default;
            Uri signUpUrl = default;
            Uri termsOfServiceUrl = default;
            Uri privacyPolicyUrl = default;
            DateTimeOffset? expectedDateOfService = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("isVanity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isVanity = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("preferredVanityNumbers"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    preferredVanityNumbers = array;
                    continue;
                }
                if (property.NameEquals("numberType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    numberType = new NumberType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isPoliticalCampaign"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isPoliticalCampaign = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("url"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    url = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("signUpTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ProgramSignUpType> array = new List<ProgramSignUpType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ProgramSignUpType(item.GetString()));
                    }
                    signUpTypes = array;
                    continue;
                }
                if (property.NameEquals("signUpUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    signUpUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("termsOfServiceUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    termsOfServiceUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("privacyPolicyUrl"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    privacyPolicyUrl = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("expectedDateOfService"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    expectedDateOfService = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new ProgramDetails(
                isVanity,
                preferredVanityNumbers ?? new ChangeTrackingList<string>(),
                numberType,
                isPoliticalCampaign,
                name,
                description,
                url,
                signUpTypes ?? new ChangeTrackingList<ProgramSignUpType>(),
                signUpUrl,
                termsOfServiceUrl,
                privacyPolicyUrl,
                expectedDateOfService);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ProgramDetails FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeProgramDetails(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
