// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> Program Brief status e.g. 'submitted', 'approved', etc. </summary>
    public readonly partial struct ProgramBriefStatus : IEquatable<ProgramBriefStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProgramBriefStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProgramBriefStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SubmittedValue = "submitted";
        private const string ApprovedValue = "approved";
        private const string SubmitNewVanityNumbersValue = "submitNewVanityNumbers";
        private const string UpdateProgramBriefValue = "updateProgramBrief";
        private const string DraftValue = "draft";
        private const string DeniedValue = "denied";

        /// <summary> submitted. </summary>
        public static ProgramBriefStatus Submitted { get; } = new ProgramBriefStatus(SubmittedValue);
        /// <summary> approved. </summary>
        public static ProgramBriefStatus Approved { get; } = new ProgramBriefStatus(ApprovedValue);
        /// <summary> submitNewVanityNumbers. </summary>
        public static ProgramBriefStatus SubmitNewVanityNumbers { get; } = new ProgramBriefStatus(SubmitNewVanityNumbersValue);
        /// <summary> updateProgramBrief. </summary>
        public static ProgramBriefStatus UpdateProgramBrief { get; } = new ProgramBriefStatus(UpdateProgramBriefValue);
        /// <summary> draft. </summary>
        public static ProgramBriefStatus Draft { get; } = new ProgramBriefStatus(DraftValue);
        /// <summary> denied. </summary>
        public static ProgramBriefStatus Denied { get; } = new ProgramBriefStatus(DeniedValue);
        /// <summary> Determines if two <see cref="ProgramBriefStatus"/> values are the same. </summary>
        public static bool operator ==(ProgramBriefStatus left, ProgramBriefStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProgramBriefStatus"/> values are not the same. </summary>
        public static bool operator !=(ProgramBriefStatus left, ProgramBriefStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProgramBriefStatus"/>. </summary>
        public static implicit operator ProgramBriefStatus(string value) => new ProgramBriefStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProgramBriefStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProgramBriefStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
