// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> Indicates the nature of the messaging associated with the program e.g. 'subscription', 'transaction'. </summary>
    public readonly partial struct MessageRecurrence : IEquatable<MessageRecurrence>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MessageRecurrence"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MessageRecurrence(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SubscriptionValue = "subscription";
        private const string TransactionValue = "transaction";

        /// <summary> subscription. </summary>
        public static MessageRecurrence Subscription { get; } = new MessageRecurrence(SubscriptionValue);
        /// <summary> transaction. </summary>
        public static MessageRecurrence Transaction { get; } = new MessageRecurrence(TransactionValue);
        /// <summary> Determines if two <see cref="MessageRecurrence"/> values are the same. </summary>
        public static bool operator ==(MessageRecurrence left, MessageRecurrence right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MessageRecurrence"/> values are not the same. </summary>
        public static bool operator !=(MessageRecurrence left, MessageRecurrence right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MessageRecurrence"/>. </summary>
        public static implicit operator MessageRecurrence(string value) => new MessageRecurrence(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MessageRecurrence other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MessageRecurrence other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
