// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> Represents a message example to be sent from or to the end user. </summary>
    public partial class MessageExample
    {
        /// <summary> Initializes a new instance of <see cref="MessageExample"/>. </summary>
        public MessageExample()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MessageExample"/>. </summary>
        /// <param name="direction"> Indicates whether the message example is supposed to be sent to or from the end user e.g. toUser. </param>
        /// <param name="text"> Actual example text for the message e.g. 'Want me to notify you when package in the way?'. </param>
        internal MessageExample(MessageDirection? direction, string text)
        {
            Direction = direction;
            Text = text;
        }

        /// <summary> Indicates whether the message example is supposed to be sent to or from the end user e.g. toUser. </summary>
        public MessageDirection? Direction { get; set; }
        /// <summary> Actual example text for the message e.g. 'Want me to notify you when package in the way?'. </summary>
        public string Text { get; set; }
    }
}
