// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.ShortCodes.Models
{
    /// <summary> Indicates whether the message example is supposed to be sent to or from the end user e.g. toUser. </summary>
    public readonly partial struct MessageDirection : IEquatable<MessageDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MessageDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MessageDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ToUserValue = "toUser";
        private const string FromUserValue = "fromUser";

        /// <summary> toUser. </summary>
        public static MessageDirection ToUser { get; } = new MessageDirection(ToUserValue);
        /// <summary> fromUser. </summary>
        public static MessageDirection FromUser { get; } = new MessageDirection(FromUserValue);
        /// <summary> Determines if two <see cref="MessageDirection"/> values are the same. </summary>
        public static bool operator ==(MessageDirection left, MessageDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MessageDirection"/> values are not the same. </summary>
        public static bool operator !=(MessageDirection left, MessageDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MessageDirection"/>. </summary>
        public static implicit operator MessageDirection(string value) => new MessageDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MessageDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MessageDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
